<?php
// --- Incluir o arquivo de conexão ---
try {
    include 'conexao.php';
    if (!isset($conn) || !$conn instanceof mysqli) {
        throw new Exception("A variável \$conn não foi definida ou não é uma conexão válida em conexao.php.");
    }
} catch (Exception $e) {
    die("Erro fatal: Não foi possível conectar ao banco de dados. Erro: " . $e->getMessage());
}

$conn_status_message = 'Pronto para edição e salvamento.';
$dados_necessidade = [];

// --- Configuração das Linhas de Levantamento ---
$categorias_docentes = [
    'BIOLOGIA', 'Química', 'História', 'Geografia', 'Francês', 'Física', 
    'Língua Portuguesa', 'L. Inglesa', 'Matemática', 'Monodocência', 
    'Ed. Física', 'Ed. Laboral', 'EVP', 'EMC'
];

$categorias_NEE = [
    'Intelectual', 'Auditiva', 'Visual'
];

$categorias_administrativas = [
    'Técnicos de Informática', 'Auxiliares Administrativos', 'Protecção Física (Guardas)', 'Aux. Limpeza'
];

$escola_id = 1; // ID de exemplo
$escola_nome = 'COMPLEXO ESCOLAR BG-1005 NOSSA SENHORA DE NAZARÉ';

// Dados de Exemplo (Mockados) - Em um cenário real, seriam puxados do banco de dados
$necessidades_mock = [
    'Língua Portuguesa' => ['existente' => 5, 'necessidade' => 2],
    'Matemática' => ['existente' => 4, 'necessidade' => 3],
    'Auxiliares Administrativos' => ['existente' => 1, 'necessidade' => 2],
    'Aux. Limpeza' => ['existente' => 1, 'necessidade' => 1],
];

$todas_categorias = array_merge($categorias_docentes, $categorias_NEE, $categorias_administrativas);

// Função para normalizar nome da categoria para uso no campo 'name' do formulário
function normalize_cat_name($name) {
    return strtolower(str_replace([' ', '/', '.'], ['_', '', ''], $name));
}
?>

<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mapa de Necessidade de Pessoal (EDITÁVEL)</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        @media print {
            /* Ocultar elementos de edição na impressão */
            .no-print, .editable-field { display: none !important; }
            td { text-align: center !important; }
            /* Estilos de impressão mantidos */
            body { padding: 0 !important; margin: 0 !important; font-size: 8pt; font-family: Arial, sans-serif; }
            .print-area { box-shadow: none; border: none !important; padding: 0 !important; margin: 0; }
            table { border-collapse: collapse; width: 100%; }
            th, td { border: 1px solid #000; padding: 2px; }
            h1 { font-size: 14pt; }
        }
        /* Estilos para o input dentro da célula da tabela */
        .input-cell input {
            background-color: transparent !important;
            border: 1px solid #ccc;
            text-align: center;
            width: 100%;
            padding: 1px;
            box-sizing: border-box;
            line-height: 1.2;
        }
        .input-cell {
            padding: 0 !important;
        }
    </style>
</head>
<body class="bg-gray-50 font-sans p-4">

    <div class="print-area bg-white p-6 rounded-xl shadow-xl w-full mx-auto max-w-7xl">
        
        <header class="text-center mb-6">
            <p class="text-xs">REPÚBLICA DE ANGOLA</p>
            <p class="text-xs">ADMINISTRAÇÃO MUNICIPAL DE BENGUELA</p>
            <p class="text-xs">DIRECÇÃO MUNICIPAL DA EDUCAÇÃO DE BENGUELA</p>
            <p class="text-sm font-semibold mt-2"><?= htmlspecialchars($escola_nome) ?></p>
            <h1 class="text-xl font-bold mb-4">MAPA DE NECESSIDADES DE FUNCIONÁRIOS</h1>
        </header>

        <div class="mb-4 no-print flex justify-between items-center">
            <p class="text-sm text-gray-600">Status: <?= $conn_status_message ?></p>
            <button onclick="window.print()" class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 transition">
                <i class="fas fa-print"></i> Imprimir Mapa
            </button>
        </div>

        <form method="POST" action="salvar_necessidades.php">
        <input type="hidden" name="escola_id" value="<?= $escola_id ?>">

        <div class="overflow-x-auto">
            <table class="min-w-full text-xs table-auto">
                <thead>
                    <tr class="bg-gray-200">
                        <th rowspan="4" class="py-2 px-3 border border-gray-400">N.º</th>
                        <th rowspan="4" class="py-2 px-3 border border-gray-400">ESCOLA</th>
                        <th rowspan="4" class="py-2 px-3 border border-gray-400">N.º DE SALAS EXISTENTES</th>
                        
                        <th colspan="<?= count($categorias_docentes) + count($categorias_NEE) ?>" class="py-2 px-3 border border-gray-400 font-bold">PROFESSORES</th>
                        <th colspan="<?= count($categorias_administrativas) ?>" class="py-2 px-3 border border-gray-400 font-bold">ADMINISTRATIVOS</th>
                    </tr>
                    
                    <tr class="bg-gray-200">
                        <th colspan="<?= count($categorias_docentes) ?>" class="py-2 px-3 border border-gray-400">Ensino Regular</th>
                        <th colspan="<?= count($categorias_NEE) ?>" class="py-2 px-3 border border-gray-400">Especial (NEE)</th>
                        <th colspan="<?= count($categorias_administrativas) ?>" class="py-2 px-3 border border-gray-400">Carreira Geral</th>
                    </tr>

                    <tr class="bg-gray-300">
                        <?php foreach ($todas_categorias as $cat): ?>
                            <th colspan="2" class="py-2 px-1 border border-gray-400 font-medium"><?= htmlspecialchars($cat) ?></th>
                        <?php endforeach; ?>
                    </tr>

                    <tr class="bg-gray-400">
                        <?php 
                        // Repete as colunas EXISTENTES e NECESSIDADES para cada categoria
                        $total_colunas = count($todas_categorias);
                        for ($i = 0; $i < $total_colunas; $i++): 
                        ?>
                            <th class="py-1 px-1 border border-gray-500">EXIST.</th>
                            <th class="py-1 px-1 border border-gray-500">NECESS.</th>
                        <?php endfor; ?>
                    </tr>
                </thead>
                <tbody>
                    
                    <tr class="hover:bg-gray-100">
                        <td class="py-1 px-3 border border-gray-400">1</td>
                        <td class="py-1 px-3 border border-gray-400 text-left font-semibold"><?= htmlspecialchars($escola_nome) ?></td>
                        
                        <td class="input-cell py-1 px-3 border border-gray-400">
                            <input type="number" name="salas_existentes" value="15" min="0">
                        </td>
                        
                        <?php foreach ($todas_categorias as $cat): 
                            $cat_key = normalize_cat_name($cat);
                            $dados = $necessidades_mock[$cat] ?? ['existente' => 0, 'necessidade' => 0];
                        ?>
                            <td class="input-cell py-1 px-1 border border-gray-400">
                                <input 
                                    type="number" 
                                    name="dados[<?= $escola_id ?>][<?= $cat_key ?>][existente]" 
                                    value="<?= $dados['existente'] ?>" 
                                    min="0"
                                    class="text-blue-700 font-bold"
                                >
                            </td>
                            <td class="input-cell py-1 px-1 border border-gray-400">
                                <input 
                                    type="number" 
                                    name="dados[<?= $escola_id ?>][<?= $cat_key ?>][necessidade]" 
                                    value="<?= $dados['necessidade'] ?>" 
                                    min="0"
                                    class="text-red-700 font-bold"
                                >
                            </td>
                        <?php endforeach; ?>
                    </tr>
                    </tbody>
            </table>
        </div>
        
        <div class="mt-6 no-print flex justify-end">
             <button type="submit" class="bg-green-600 text-white px-6 py-3 rounded-lg hover:bg-green-700 transition font-semibold">
                Salvar Alterações
            </button>
        </div>

        </form>
        <footer class="mt-6 text-right text-xs">
            <p>Data de Emissão: <?= date('d/m/Y') ?></p>
        </footer>

    </div>

</body>
</html>